<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;
use App\Models\Users;

class UserController extends Controller
{
	public function index()
  	{
        $data = [];
        $url = url('/');
        $data['TYPE'] = 'admin';
  		return view('admin.user.index',$data);
	}

    public function index_ajax_user_list()
    {
        #logged_in();
        $status_array = array(0=>"Idle",1=>"Active",2=>"Delete");
        $recordsTotal = Users::count_all();
        $data = Users::get_data_table();
        if($data)
        {
            foreach ($data as $row)
            {
                $row->status_label = isset($status_array[$row->status]) ? $status_array[$row->status] : 'NA';
                if($row->photo){
                    $row->photo = url('').'/user/'.$row->id.'/'.$row->photo;
                }
            }
        }
        $output = array(
                'status'=>1,
                'message'=>'success',
                "recordsTotal" => $recordsTotal,
                "recordsFiltered" => $recordsTotal,
                "data" => $data,
                );

        return Response::json($output, 200);
    }

    public function save(Request $request)
    {
        $customMessages = [
            'name' => 'My Name is Required',
        ];

        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'name' => 'required',
            'email' => 'required|email|unique:users'. ($id ? ",email,$id" : ''),
            'mobile' => 'required',
        ], $customMessages);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Users::find($request->id);
        }else{
            $data = new Users;
        }
        $data->name = $request->name;
        $data->email = $request->email;
        $data->mobile = $request->mobile;
        $data->save();

        if($request->id){
            $msg = 'Updated';
        }else{
            $id = $data->id;
            $msg = 'Inserted';
            $data =  Users::find($id);
        }

        $path = public_path().'/user/'.$id;
        $photo = '';
        if($request->hasFile('photo')){
            $file = $request->file('photo');
            $OriginalName = $file->getClientOriginalName();
            $filename = pathinfo($OriginalName, PATHINFO_FILENAME);
            $photo = time() . '_' .$filename. '.' .$file->extension();
            $file->move($path, $photo);
        }
        if($photo){
            $data->photo = $photo;
        }
        $data->save();
        return Response::json([
                        'status'  => true,
                        'message' => 'User '.$msg.' Successfully',
                        ]);

    }

    public function enable(Request $request)
    {
        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'id' => 'required',
        ]);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Users::find($request->id);
        }
        $data->status = '1';
        $data->save();

        $msg = 'enabled';

        return Response::json([
                        'status'  => true,
                        'message' => 'User '.$msg.' Successfully',
                        ]);

    }

    public function disable(Request $request)
    {
        $id = $request->id;
        $validator = Validator::make($request->all(),[
            'id' => 'required',
        ]);

        if($validator->fails())
              return $this->setValidatorError($validator,1);

        if($request->id){
            $data =  Users::find($request->id);
        }
        $data->status = '0';
        $data->save();

        $msg = 'disabled';

        return Response::json([
                        'status'  => true,
                        'message' => 'User '.$msg.' Successfully',
                        ]);

    }
}
